<?php
// --- DEBUGGER SETUP ---
// Set error reporting to log all errors
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

// Log file path
$debug_log_file = __DIR__ . '/debug_log.txt';

// Custom error handler to log errors
function customErrorHandler($errno, $errstr, $errfile, $errline) {
    global $debug_log_file;
    $msg = "[".date('Y-m-d H:i:s')."] ERROR $errno: $errstr in $errfile on line $errline\n";
    error_log($msg, 3, $debug_log_file);
    return false; // Let PHP handle as well
}
set_error_handler("customErrorHandler");

// Custom exception handler to log exceptions
function customExceptionHandler($exception) {
    global $debug_log_file;
    $msg = "[".date('Y-m-d H:i:s')."] UNCAUGHT EXCEPTION: ".$exception->getMessage()." in ".$exception->getFile()." on line ".$exception->getLine()."\n";
    error_log($msg, 3, $debug_log_file);
}
set_exception_handler('customExceptionHandler');

// Log PHP version and loaded extensions at the start
if (!file_exists($debug_log_file) || filesize($debug_log_file) < 10) {
    $phpinfo = "PHP Version: " . phpversion() . "\n";
    $phpinfo .= "Loaded Extensions: " . implode(', ', get_loaded_extensions()) . "\n";
    $phpinfo .= "Server: " . (isset($_SERVER['SERVER_SOFTWARE']) ? $_SERVER['SERVER_SOFTWARE'] : 'CLI') . "\n";
    error_log("==== DEBUG SESSION START ".date('Y-m-d H:i:s')." ====\n$phpinfo\n", 3, $debug_log_file);
}

// Helper to log checkpoints
function debug_log($msg) {
    global $debug_log_file;
    error_log("[".date('Y-m-d H:i:s')."] $msg\n", 3, $debug_log_file);
}

// --- END DEBUGGER SETUP ---

// --- SESSION FIXES ---
// Start session as early as possible, before any output
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>

<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<link rel="stylesheet" href="confirm.css">
<script src="confirm.js"></script>
<script type="text/javascript" src="jquery-3.3.1.min.js"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.0.0/jquery.min.js"></script>
<script>
     function add_commas(number){
    number=number.replace(/,/g, "");
    number = '' + number;
    if (number.length > 3) {
        var mod = number.length % 3;
        var output = (mod > 0 ? (number.substring(0,mod)) : '');
        for (i=0 ; i < Math.floor(number.length / 3); i++) {
            if ((mod == 0) && (i == 0))
                output += number.substring(mod+ 3 * i, mod + 3 * i + 3);
            else
                output+= ',' + number.substring(mod + 3 * i, mod + 3 * i + 3);
        }
        return (output);
    }
    else return number;
}
</script>
<style>
    input{font-size: 30px;}
</style>
<script>
    $('input.number').keyup(function(event) {
      if(event.which >= 37 && event.which <= 40) return;
      $(this).val(function(index, value) {
        return value
        .replace(/\D/g, "")
        .replace(/\B(?=(\d{3})+(?!\d))/g, ",")
        ;
      });
    });
</script>
<style>
    .transfer_table td {color:white;}
</style>
</head>
<body>
<div id="dialogoverlay"></div>
<div id="dialogbox">
  <div>
    <div id="dialogboxhead"></div>
    <div id="dialogboxbody"></div>
    <div id="dialogboxfoot"></div>
  </div>
</div>
</body>
</html>

<?php
try {
    debug_log("Including DB connection...");
    require_once('../Connections/bnkconn.php');
    debug_log("DB connection included.");

    ob_start();
    sleep(4);

    // Check for session variable before using
    if (!isset($_SESSION['act_number'])) {
        debug_log("ERROR: act_number not set in session. Redirecting to login.");
        header("Location: login.php");
        exit;
    }

    //custom_mysql_select_db($database_bnkconn);
    debug_log("Fetching sender details...");
    $sender = custom_mysql_fetch_array(custom_mysql_query("select * from act_holder_details where cust_act_number = '".custom_mysql_real_escape_string($_SESSION['act_number'])."'"));
    $currency = isset($sender['currency']) ? $sender['currency'] : '';
    
    unset($_SESSION['email_sent']);
unset($_SESSION['email_sent1']);
unset($_SESSION['email_sent2']);
unset($_SESSION['email_sent3']);
unset($_SESSION['debit_email_sent']);

    $MM_authorizedUsers = "";
    $MM_donotCheckaccess = "true";

    function isAuthorized($strUsers, $strGroups, $UserName, $UserGroup) { 
      $isValid = False; 
      if (!empty($UserName)) { 
        $arrUsers = Explode(",", $strUsers); 
        $arrGroups = Explode(",", $strGroups); 
        if (in_array($UserName, $arrUsers)) { 
          $isValid = true; 
        } 
        if (in_array($UserGroup, $arrGroups)) { 
          $isValid = true; 
        } 
        if (($strUsers == "") && true) { 
          $isValid = true; 
        } 
      } 
      return $isValid; 
    }

    $username = isset($_SESSION['username']) ? $_SESSION['username'] : "";
    $MM_UserGroup = isset($_SESSION['MM_UserGroup']) ? $_SESSION['MM_UserGroup'] : "";

    // Fix: define $MM_restrictGoTo to avoid undefined variable
    $MM_restrictGoTo = "login.php";

    if (!((isset($_SESSION['username'])) && (isAuthorized("", $MM_authorizedUsers, $username, $MM_UserGroup)))) {   
      $MM_qsChar = "?";
      $MM_referrer = $_SERVER['PHP_SELF'];

      // Fix: check $MM_restrictGoTo is string before strpos
      if (!empty($MM_restrictGoTo) && strpos($MM_restrictGoTo, "?") !== false) $MM_qsChar = "&";
      if (isset($_SERVER['QUERY_STRING']) && strlen($_SERVER['QUERY_STRING']) > 0) 
        $MM_referrer .= "?" . $_SERVER['QUERY_STRING'];
      $MM_restrictGoTo = $MM_restrictGoTo . $MM_qsChar . "accesscheck=" . urlencode($MM_referrer);
      $page = 0;
      debug_log("User not authorized, redirecting to: $MM_restrictGoTo");
      // Fix: ensure no output before header
      if (!headers_sent()) {
        header("Location: ". $MM_restrictGoTo); 
        exit;
      } else {
        echo "<script>window.location.href='" . htmlspecialchars($MM_restrictGoTo, ENT_QUOTES) . "';</script>";
        exit;
      }
    }

    if (!function_exists("GetSQLValueString")) {
    function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "") 
    {
      if (PHP_VERSION < 6) {
        $theValue = get_magic_quotes_gpc() ? stripslashes($theValue) : $theValue;
      }
      $theValue = custom_mysql_real_escape_string($theValue);
      switch ($theType) {
        case "text":
          $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
          break;    
        case "long":
        case "int":
          $theValue = ($theValue != "") ? intval($theValue) : "NULL";
          break;
        case "double":
          $theValue = ($theValue != "") ? doubleval($theValue) : "NULL";
          break;
        case "date":
          $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
          break;
        case "defined":
          $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
          break;
      }
      return $theValue;
    }
    }

    $colname_prinacc = "-1";
    if (isset($_SESSION['act_number'])) {
      $colname_prinacc = $_SESSION['act_number'];
    }
    $query_prinacc = sprintf("SELECT * FROM `transaction` WHERE act_number = %s ORDER BY id DESC", GetSQLValueString($colname_prinacc, "text"));
    debug_log("Querying principal account: $query_prinacc");
    $prinacc = custom_mysql_query($query_prinacc) or die(custom_mysql_error());
    $row_prinacc = custom_mysql_fetch_assoc($prinacc);
    $totalRows_prinacc = custom_mysql_num_rows($prinacc);

    include('header.php');

    $act_number = $_SESSION['act_number']; 
    $status_check = custom_mysql_fetch_object(custom_mysql_query("SELECT `account_transfer`,`transfer_page_message` FROM `act_holder_details` WHERE `cust_act_number`='".custom_mysql_real_escape_string($act_number)."'")); 
    $isufficent = 0;
    if(isset($_REQUEST['transfer'])) {
        debug_log("Transfer request received.");
        if($status_check && $status_check->account_transfer == 0){
            debug_log("Account transfer is disabled, redirecting to transfer_suspended.php");
            if (!headers_sent()) {
                header('Location: transfer_suspended.php');
                exit;
            } else {
                echo "<script>window.location.href='transfer_suspended.php';</script>";
                exit;
            }
        }

        $character_array = array_merge(range("a", "z"), range(0, 9));
        $string = "";
        for($i = 0; $i < 6; $i++) {
            $string .= $character_array[rand(0, (count($character_array) - 1))];
        }
        $transaction_id = $string;

        $date = date('Y-m-d');
        $act_number = $_REQUEST['act_number'];
        $_SESSION['rec'] = $act_number;
        $bank_name = $_REQUEST['swift'];
        $branch_name = $_REQUEST['branch_name'];
        $purpose = $_REQUEST['purpose'];
        $ifsc_code = $_REQUEST['ifsc_code'];
        $_SESSION['ifsc'] = $ifsc_code;

        $amount = $_REQUEST['amount'];
        $amount = intval(preg_replace('/[^\d.]/', '', $amount));
        $branch_add = $_REQUEST['branch_add'];
        $cust_name = $_REQUEST['cust_name'];
        $_SESSION['cust_name'] = $cust_name;
        $number = $_REQUEST['number'];
        $branch = $_REQUEST['branch_add'];
        $swift = $_REQUEST['swift'];
        $_SESSION['branch'] = $branch_add;
        $_SESSION['branch_name'] = $branch_name;
        $address = $_REQUEST['address'];
        $prinacc22 = $_REQUEST['prinacc22'];

        $_SESSION['t_id'] = $transaction_id;
        $authcode = rand(100000,999999999);
        $bankid = rand(100000,999999999);
        $s_code = rand(100000,999999999);

        $sender_act_number = $_SESSION['act_number']; 
        $sender_latest_data = custom_mysql_fetch_array(custom_mysql_query("select max(id) as id from transaction where act_number = '".custom_mysql_real_escape_string($sender_act_number)."' "));
        $present_balance = custom_mysql_fetch_array(custom_mysql_query("select * from transaction where act_number = '".custom_mysql_real_escape_string($sender_act_number)."' and id = '".$sender_latest_data[0]."' "));

        $beneficiary = custom_mysql_query("insert into business_user (name,address,country,account_no,bank_name,bank_address,swift,sort_code,added_by) values('".custom_mysql_real_escape_string($cust_name)."', '".custom_mysql_real_escape_string($address)."','".custom_mysql_real_escape_string($prinacc22)."','".custom_mysql_real_escape_string($act_number)."','".custom_mysql_real_escape_string($branch_name)."','".custom_mysql_real_escape_string($branch)."','".custom_mysql_real_escape_string($swift)."','".custom_mysql_real_escape_string($ifsc_code)."','".custom_mysql_real_escape_string(isset($_SESSION["username"])?$_SESSION["username"]:"")."')");
        if($present_balance && $present_balance['present_balance'] >= $amount ){
            $now_balance_sender = $present_balance['present_balance'];

            $sender_name = custom_mysql_fetch_object(custom_mysql_query("SELECT `cust_name`, `bankidreq`, `authcodereq`, `clearancereq`,`currency` FROM `act_holder_details` WHERE `cust_act_number`='".custom_mysql_real_escape_string($sender_act_number)."'"));
            $isDataFetchedForSenderName = false;

            if($sender_name){
              $cust_name = $sender_name->cust_name;
              $currency = $sender_name->currency;
              $isDataFetchedForSenderName = true;
            }

            // The following block is a direct copy of the original, with debug logs added
            $get_details = array('ifcs_code' => $ifsc_code); // fallback for undefined variable
            if($isDataFetchedForSenderName && $sender_name->bankidreq=="1" && $sender_name->authcodereq=="1" && $sender_name->clearancereq=="1") {
                debug_log("Inserting transaction with bankid, authcode, security");
                $transaction_record_sender = custom_mysql_query("insert into transaction (act_number,ifsc_code,transaction_id,transaction_date,debited,present_balance,branch_name,branch_add,cust_name,description,status,number,bankid,authcode,security,stage) values('".custom_mysql_real_escape_string($sender_act_number)."','".$get_details['ifcs_code']."','".$transaction_id."','".$date."','".$amount."','".$now_balance_sender."','".$branch_name."','".$branch_add."','".$cust_name."','".$purpose."','0','".$number."','".rand(100000,999999)."','".rand(100000,999999)."','".rand(100000,999999)."',0)");
            }
            else if($isDataFetchedForSenderName && $sender_name->bankidreq=="1" && $sender_name->authcodereq=="1") {
                debug_log("Inserting transaction with bankid, authcode");
                $transaction_record_sender = custom_mysql_query("insert into transaction (act_number,ifsc_code,transaction_id,transaction_date,debited,present_balance,branch_name,branch_add,cust_name,description,status,number,bankid,authcode,stage) values('".custom_mysql_real_escape_string($sender_act_number)."','".$get_details['ifcs_code']."','".$transaction_id."','".$date."','".$amount."','".$now_balance_sender."','".$branch_name."','".$branch_add."','".$cust_name."','".$purpose."','0','".$number."','".rand(100000,999999)."','".rand(100000,999999)."',0)");
            }
            else if($isDataFetchedForSenderName && $sender_name->bankidreq=="1" && $sender_name->clearancereq=="1") {
                debug_log("Inserting transaction with bankid, security");
                $transaction_record_sender = custom_mysql_query("insert into transaction (act_number,ifsc_code,transaction_id,transaction_date,debited,present_balance,branch_name,branch_add,cust_name,description,status,number,bankid,security,stage) values('".custom_mysql_real_escape_string($sender_act_number)."','".$get_details['ifcs_code']."','".$transaction_id."','".$date."','".$amount."','".$now_balance_sender."','".$branch_name."','".$branch_add."','".$cust_name."','".$purpose."','0','".$number."','".rand(100000,999999)."','".rand(100000,999999)."',0)");
            }
            else if($isDataFetchedForSenderName && $sender_name->authcodereq=="1" && $sender_name->clearancereq=="1") {
                debug_log("Inserting transaction with authcode, security");
                $transaction_record_sender = custom_mysql_query("insert into transaction (act_number,ifsc_code,transaction_id,transaction_date,debited,present_balance,branch_name,branch_add,cust_name,description,status,number,authcode,security,stage) values('".custom_mysql_real_escape_string($sender_act_number)."','".$get_details['ifcs_code']."','".$transaction_id."','".$date."','".$amount."','".$now_balance_sender."','".$branch_name."','".$branch_add."','".$cust_name."','".$purpose."','0','".$number."','".rand(100000,999999)."','".rand(100000,999999)."',0)");
            }
            else if($isDataFetchedForSenderName && $sender_name->authcodereq=="0" && $sender_name->clearancereq=="0" && $sender_name->bankidreq=="0") {
                debug_log("Inserting transaction with no codes");
                $transaction_record_sender = custom_mysql_query("insert into transaction (act_number,ifsc_code,transaction_id,transaction_date,debited,present_balance,branch_name,branch_add,cust_name,description,status,number,stage) values('".custom_mysql_real_escape_string($sender_act_number)."','".$get_details['ifcs_code']."','".$transaction_id."','".$date."','".$amount."','".$now_balance_sender."','".$branch_name."','".$branch_add."','".$cust_name."','".$purpose."','0','".$number."',0)");
            }
            else if($isDataFetchedForSenderName && $sender_name->bankidreq=="1") {
                debug_log("Inserting transaction with bankid");
                $transaction_record_sender = custom_mysql_query("insert into transaction (act_number,ifsc_code,transaction_id,transaction_date,debited,present_balance,branch_name,branch_add,cust_name,description,status,number,bankid,stage) values('".custom_mysql_real_escape_string($sender_act_number)."','".$get_details['ifcs_code']."','".$transaction_id."','".$date."','".$amount."','".$now_balance_sender."','".$branch_name."','".$branch_add."','".$cust_name."','".$purpose."','0','".$number."','".rand(100000,999999)."',0)");
            }
            else if($isDataFetchedForSenderName && $sender_name->authcodereq=="1") {
                debug_log("Inserting transaction with authcode");
                $transaction_record_sender = custom_mysql_query("insert into transaction (act_number,ifsc_code,transaction_id,transaction_date,debited,present_balance,branch_name,branch_add,cust_name,description,status,number,authcode,stage) values('".custom_mysql_real_escape_string($sender_act_number)."','".$get_details['ifcs_code']."','".$transaction_id."','".$date."','".$amount."','".$now_balance_sender."','".$branch_name."','".$branch_add."','".$cust_name."','".$purpose."','0','".$number."','".rand(100000,999999)."',0)");
            }
            else if($isDataFetchedForSenderName && $sender_name->clearancereq=="1") {
                debug_log("Inserting transaction with security");
                $transaction_record_sender = custom_mysql_query("insert into transaction (act_number,ifsc_code,transaction_id,transaction_date,debited,present_balance,branch_name,branch_add,cust_name,description,status,number,security,stage) values('".custom_mysql_real_escape_string($sender_act_number)."','".$get_details['ifcs_code']."','".$transaction_id."','".$date."','".$amount."','".$now_balance_sender."','".$branch_name."','".$branch_add."','".$cust_name."','".$purpose."','0','".$number."','".rand(100000,999999)."',0)");
            }
            else {
                debug_log("Inserting transaction with all codes (fallback)");
                $transaction_record_sender = custom_mysql_query("insert into transaction (act_number,ifsc_code,transaction_id,transaction_date,debited,present_balance,branch_name,branch_add,cust_name,description,status,number,bankid,authcode,security,stage) values('".custom_mysql_real_escape_string($sender_act_number)."','".$get_details['ifcs_code']."','".$transaction_id."','".$date."','".$amount."','".$now_balance_sender."','".$branch_name."','".$branch_add."','".$cust_name."','".$purpose."','0','".$number."','".$bankid."','".$authcode."','".$s_code."',0)"); 
            }

            $sender_email = custom_mysql_fetch_array(custom_mysql_query("select * from act_holder_details where cust_act_number = '".custom_mysql_real_escape_string($sender_act_number)."'"));
            $email = isset($sender_email['cust_mail']) ? $sender_email['cust_mail'] : '';
            $admin_email_obj = custom_mysql_fetch_object(custom_mysql_query("SELECT * FROM `admin`"));
            $admin_email = $admin_email_obj ? $admin_email_obj->email : '';
            $to = $email; 
            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=iso-8859-1" . "\r\n";
            $headers .= 'From: '.$admin_email."\r\n";
            $subject  =  'Bahamas Financial Services Board alert' ;
            $message  = 'Your Transfer Request is Initiated';

            debug_log("Sending mail to $to...");
            if(mail($to,$subject,$message,$headers)){
                debug_log("Mail sent successfully.");
                $page = 0;
                $sender_latest_data2 = custom_mysql_fetch_array(custom_mysql_query("select max(id) as id from transaction where act_number = '".custom_mysql_real_escape_string($sender_act_number)."'"));
                $_SESSION['idforproc'] = $sender_latest_data2[0];
                $sender_id = custom_mysql_fetch_object(custom_mysql_query("SELECT * FROM transaction WHERE id ='". custom_mysql_real_escape_string($sender_latest_data2[0]). "'"));
                $sql_insert_account = custom_mysql_query("INSERT INTO `transfer_details` (`id` ,`account`,`ifsc`,`branch`,`t_id`,`branch_name`,`cust_name`) VALUES ('".custom_mysql_real_escape_string($sender_latest_data2[0])."','".custom_mysql_real_escape_string($_SESSION['rec'])."','".custom_mysql_real_escape_string($_SESSION['ifsc'])."','".custom_mysql_real_escape_string($_SESSION['branch'])."','".custom_mysql_real_escape_string($_SESSION['t_id'])."','".custom_mysql_real_escape_string($_SESSION['branch_name'])."','".custom_mysql_real_escape_string($_SESSION['cust_name'])."')");
                $getbankid = isset($sender_id->bankid) ? $sender_id->bankid : '';
                $getauth = isset($sender_id->authcode) ? $sender_id->authcode : '';
                $getcode = isset($sender_id->security) ? $sender_id->security : '';
                if($getbankid==1 && $getauth==1 && $getcode==1)
                {
                    $message="Your Transfer Request is Initiated . Here is your Bank-id for transfer   ".$getbankid. "Auth-code for transfer is   ".$getauth ."Security_clearance code for transfer is  ".$getcode;
                }  
                else
                {
                    $message ="Your Transfer Request is Initiated!";
                    if($getbankid==1) 
                    {
                        $message=$message. " Your bankid is  ".$getbankid;
                    }
                    if($getauth==1)
                        $message=$message."Your Auth code is  ".$getauth;
                    if($getcode==1)
                    {
                        $message=$message."Your Security clearancer code is  ". $getcode;
                    }
                }
                // mail($to,$subject,$message,$headers);        ///send codes
                $page = 0;
                $update_bank_data = custom_mysql_query("UPDATE transaction SET stage = '".$page."' WHERE id = '".custom_mysql_real_escape_string($sender_latest_data2[0])."'");
                debug_log("Redirecting to success_page.php");
                echo "<script type=\"text/javascript\">
location.href = \"success_page.php?amount=$amount&acc=$act_number&ban_name=$bank_name&brnch_nm=$branch_name&br_add=$branch_add&b_code=$ifsc_code\";
</script>";
            }
            else{
                debug_log("Mail not sent.");
                echo "Mail Not Sent";	exit;	
            }
        }
        else
        {
            debug_log("Insufficient funds: present_balance=".(isset($present_balance['present_balance'])?$present_balance['present_balance']:'NULL').", amount=$amount");
            $isufficent = 1;
        }
    }
} catch (Throwable $e) {
    // Log any fatal error
    debug_log("FATAL ERROR: ".$e->getMessage()." in ".$e->getFile()." on line ".$e->getLine());
    echo "<div style='color:red'>A fatal error occurred. Please check the debug log for details.</div>";
}
?>

<style type="text/css">
.red {	color: #F00;
}
</style>

<?php
       if( isset($isufficent) && $isufficent==1)
       {?>
<div class="alert">
  <span class="closebtn" onclick="this.parentElement.style.display='none';">&times;</span> 
   <h3 style='color:red'>
       <?php
           echo " Insufficient Fund in your account";
       ?>
       </h3>
       </div>
       <?php
       }?>
			<div>
				<ul class="breadcrumb">
					<li>
						<a href="dashboard.php">Home</a> <span class="divider">/</span>
					</li>
					<li>
						<a href="#">Fund Transfer</a>
					</li>
				</ul>
			</div>
            
            			<?php include "menu.php";?>
			
			<div class="row-fluid sortable">
			  <div class="box span12">
			    <div class="box-header well" style="background: rgba(0, 0, 0, 0.5);;padding:15px;color:white" data-original-title="data-original-title">
			      <h2>Instant Funds Transfer Request</h2>
			      <div style="clear: none; float: right; height: 18px; margin: -1px 2px 0;">
			        <!--<a href="viewpages.php" title="Add New Page" data-rel="tooltip" class="btn btn-warning">View Pages</a>-->
			        <!--<a href="#" class="btn btn-setting btn-round"><i class="icon-cog"></i></a>-->
			        <!--<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
							<a href="#" class="btn btn-close btn-round"><i class="icon-remove"></i></a>-->
		          </div>
		        </div>
			    <div class="box-content">
			      <div class="form-actions">
			        <div id="SERVERSIDEERROR" class="errContainerError"> 
			          <p>Please Note: Request received before 2pm (PST) will be treated same day, while those received after 2pm (GMT +2) will be treated next   business day. Processing of any request is subject to compliance with local regulations.</p>
			          <p><strong>Details of Charges per (transaction)</strong> -   Commission: 0.5% of Transaction (<strong>subject to a minimum of 10 units of the currency</strong>),  VAT: 5% of Commssion, Telex: $20  (or its equivalent in the currency being transferred).  Off Shore Charges: USD: $25, GBP: £12, Euro: <strong>€</strong>15.</p>
		                 *  Pound Sterling requires Sort Code <br />
		                 *  EURO requires IBAN_NO &amp; BIC
			          <p>Please ensure that your account is funded up to the required amount including charges to avoid your transaction being rejected.   To initiate a new request, kindly fill the form below. </p>
			          <p><span class="red"><strong>Please Note: You require a  token to complete third party transfers</strong></span><strong>.</strong></p>
		            </div>
			        <br />
			      </div>
		        </div>
		      </div>
			  <!--/span-->
</div>

<!--<div class="red">This account has been blocked for further sending funds</div>-->
			<div class="row-fluid sortable">
				<div class="box span12">
					<div class="box-header well" style="background: rgba(0, 0, 0, 0.5);padding:15px;color:white" data-original-title>
						<h2>Transfer Details</h2>
						<div style="clear: none; float: right; height: 18px; margin: -1px 2px 0;">
						<!--<a href="viewpages.php" title="Add New Page" data-rel="tooltip" class="btn btn-warning">View Pages</a>-->
							<!--<a href="#" class="btn btn-setting btn-round"><i class="icon-cog"></i></a>-->
							<!--<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
							<a href="#" class="btn btn-close btn-round"><i class="icon-remove"></i></a>-->
						</div>
					</div>
					<div class="box-content" style="background: rgba(0, 0, 0, 0.5);color:white;padding:10px">
                    						<form class="form-horizontal" action="fund_transferx.php" method="post">
						  <fieldset class="item">

						<table width="100%" style="color:white" border="0" class="transfer_table">
						  <tr>
						    <td colspan="2"  class="form-actions" style="background: rgba(0, 0, 0, 0);color:white"><h4 style="color:white;font-size:20px;font-wight:bold">Sender Details:</h4></td>
						    <td width="2%">&nbsp;</td>
					      </tr>
						  <tr>
						    <td width="10%"><span>Account to debit for principal </span></td>
						    <td width="30%"><span class="controls">
						      <select name="prinacc" id="prinacc">
						       
						        <option value="<?php echo number_format($row_prinacc['present_balance'],2,'.',','); ?>"><?php echo $row_prinacc['act_number']?> --- <?php echo number_format($row_prinacc['present_balance'],2,'.',','); ?></option>
						       
					        </select>
						    </span></td>
						    <td>&nbsp;</td>
					      </tr>
					      
					      
						  <tr>

						    <td><span>Amount</span></td>
						    <td><span class="controls">
						      <input name="amount" type="text" required class="input-xlarge focused" onkeyup="this.value=add_commas(this.value);" id="am" value="" size="20" />
						    </span></td>
						    <td>&nbsp;</td>
					      </tr>
						  <tr>
						    <td><span>Currency</span></td>
						    <td><span class="controls">
						      <input name="currency" type="text" disabled="disabled" id="currency" value="<?php echo $currency; ?>" size="4" readonly />
						    </span></td>
						    <td>&nbsp;</td>
					      </tr>
						  <tr>
						    <td><span>Account to debit for
commission, VAT and telex charges: </span></td>
						    <td><span class="controls">
						      <select name="amt" id="">
						    
						        <option value="<?php echo number_format($row_prinacc['present_balance'],2,'.',','); ?>"><?php echo $row_prinacc['act_number']?> --- <?php echo number_format($row_prinacc['present_balance'],2,'.',','); ?></option>
						      
					        </select>
						    </span></td>
						    <td>&nbsp;</td>
					      </tr>
						  <tr>
						    <td colspan="2" class="form-actions" style="background: rgba(0, 0, 0, 0);color:white"><h4 style="color:white;font-size:20px;font-wight:bold">Beneficiary Details:</h4></td>
						    <td>&nbsp;</td>
					      </tr>
						  <tr>
						    <td>&nbsp;</td>
						    <td>&nbsp;</td>
						    <td>&nbsp;</td>
					      </tr>
					      
						    <td><label for="date5">Beneficiary Name</label>						      </td>
						    <td><span class="controls">
						      <input class="input-xlarge focused" id="cust_name" name="cust_name" type="text" value="" required />
						      </span></td>
						    <td>&nbsp;</td>
					      </tr>
						  <tr>
						    <td><label for="date5">Beneficiary Address</label></td>
						    <td><span class="controls">
						      <input class="input-xlarge focused" id="address" name="address" type="text" value="" required />
						      </span></td>
						    <td>&nbsp;</td>
					      </tr>
<tr>
  <td>Beneficiary Country</td>
  <td>
    <span class="controls">
      <select name="prinacc22" id="prinacc2" required>
        <option value="" selected="selected">Country...</option>
        <option value="Afghanistan">Afghanistan</option>
        <option value="Albania">Albania</option>
        <option value="Algeria">Algeria</option>
        <option value="Andorra">Andorra</option>
        <option value="Angola">Angola</option>
        <option value="Antigua and Barbuda">Antigua and Barbuda</option>
        <option value="Argentina">Argentina</option>
        <option value="Armenia">Armenia</option>
        <option value="Australia">Australia</option>
        <option value="Austria">Austria</option>
        <option value="Azerbaijan">Azerbaijan</option>
        <option value="Bahamas">Bahamas</option>
        <option value="Bahrain">Bahrain</option>
        <option value="Bangladesh">Bangladesh</option>
        <option value="Barbados">Barbados</option>
        <option value="Belarus">Belarus</option>
        <option value="Belgium">Belgium</option>
        <option value="Belize">Belize</option>
        <option value="Benin">Benin</option>
        <option value="Bhutan">Bhutan</option>
        <option value="Bolivia">Bolivia</option>
        <option value="Bosnia and Herzegovina">Bosnia and Herzegovina</option>
        <option value="Botswana">Botswana</option>
        <option value="Brazil">Brazil</option>
        <option value="Brunei">Brunei</option>
        <option value="Bulgaria">Bulgaria</option>
        <option value="Burkina Faso">Burkina Faso</option>
        <option value="Burundi">Burundi</option>
        <option value="Cambodia">Cambodia</option>
        <option value="Cameroon">Cameroon</option>
        <option value="Canada">Canada</option>
        <option value="Cape Verde">Cape Verde</option>
        <option value="Central African Republic">Central African Republic</option>
        <option value="Chad">Chad</option>
        <option value="Chile">Chile</option>
        <option value="China">China</option>
        <option value="Colombia">Colombia</option>
        <option value="Comoros">Comoros</option>
        <option value="Congo (Brazzaville)">Congo (Brazzaville)</option>
        <option value="Congo (Kinshasa)">Congo (Kinshasa)</option>
        <option value="Costa Rica">Costa Rica</option>
        <option value="Croatia">Croatia</option>
        <option value="Cuba">Cuba</option>
        <option value="Cyprus">Cyprus</option>
        <option value="Czech Republic">Czech Republic</option>
        <option value="Denmark">Denmark</option>
        <option value="Djibouti">Djibouti</option>
        <option value="Dominica">Dominica</option>
        <option value="Dominican Republic">Dominican Republic</option>
        <option value="Ecuador">Ecuador</option>
        <option value="Egypt">Egypt</option>
        <option value="El Salvador">El Salvador</option>
        <option value="Equatorial Guinea">Equatorial Guinea</option>
        <option value="Eritrea">Eritrea</option>
        <option value="Estonia">Estonia</option>
        <option value="Eswatini">Eswatini</option>
        <option value="Ethiopia">Ethiopia</option>
        <option value="Fiji">Fiji</option>
        <option value="Finland">Finland</option>
        <option value="France">France</option>
        <option value="Gabon">Gabon</option>
        <option value="Gambia">Gambia</option>
        <option value="Georgia">Georgia</option>
        <option value="Germany">Germany</option>
        <option value="Ghana">Ghana</option>
        <option value="Greece">Greece</option>
        <option value="Grenada">Grenada</option>
        <option value="Guatemala">Guatemala</option>
        <option value="Guinea">Guinea</option>
        <option value="Guinea-Bissau">Guinea-Bissau</option>
        <option value="Guyana">Guyana</option>
        <option value="Haiti">Haiti</option>
        <option value="Honduras">Honduras</option>
        <option value="Hungary">Hungary</option>
        <option value="Iceland">Iceland</option>
        <option value="India">India</option>
        <option value="Indonesia">Indonesia</option>
        <option value="Iran">Iran</option>
        <option value="Iraq">Iraq</option>
        <option value="Ireland">Ireland</option>
        <option value="Israel">Israel</option>
        <option value="Italy">Italy</option>
        <option value="Jamaica">Jamaica</option>
        <option value="Japan">Japan</option>
        <option value="Jordan">Jordan</option>
        <option value="Kazakhstan">Kazakhstan</option>
        <option value="Kenya">Kenya</option>
        <option value="Kiribati">Kiribati</option>
        <option value="Kuwait">Kuwait</option>
        <option value="Kyrgyzstan">Kyrgyzstan</option>
        <option value="Laos">Laos</option>
        <option value="Latvia">Latvia</option>
        <option value="Lebanon">Lebanon</option>
        <option value="Lesotho">Lesotho</option>
        <option value="Liberia">Liberia</option>
        <option value="Libya">Libya</option>
        <option value="Liechtenstein">Liechtenstein</option>
        <option value="Lithuania">Lithuania</option>
        <option value="Luxembourg">Luxembourg</option>
        <option value="Madagascar">Madagascar</option>
        <option value="Malawi">Malawi</option>
        <option value="Malaysia">Malaysia</option>
        <option value="Maldives">Maldives</option>
        <option value="Mali">Mali</option>
        <option value="Malta">Malta</option>
        <option value="Marshall Islands">Marshall Islands</option>
        <option value="Mauritania">Mauritania</option>
        <option value="Mauritius">Mauritius</option>
        <option value="Mexico">Mexico</option>
        <option value="Micronesia">Micronesia</option>
        <option value="Moldova">Moldova</option>
        <option value="Monaco">Monaco</option>
        <option value="Mongolia">Mongolia</option>
        <option value="Montenegro">Montenegro</option>
        <option value="Morocco">Morocco</option>
        <option value="Mozambique">Mozambique</option>
        <option value="Myanmar">Myanmar</option>
        <option value="Namibia">Namibia</option>
        <option value="Nauru">Nauru</option>
        <option value="Nepal">Nepal</option>
        <option value="Netherlands">Netherlands</option>
        <option value="New Zealand">New Zealand</option>
        <option value="Nicaragua">Nicaragua</option>
        <option value="Niger">Niger</option>
        <option value="Nigeria">Nigeria</option>
        <option value="North Korea">North Korea</option>
        <option value="North Macedonia">North Macedonia</option>
        <option value="Norway">Norway</option>
        <option value="Oman">Oman</option>
        <option value="Pakistan">Pakistan</option>
        <option value="Palau">Palau</option>
        <option value="Palestine">Palestine</option>
        <option value="Panama">Panama</option>
        <option value="Papua New Guinea">Papua New Guinea</option>
        <option value="Paraguay">Paraguay</option>
        <option value="Peru">Peru</option>
        <option value="Philippines">Philippines</option>
        <option value="Poland">Poland</option>
        <option value="Portugal">Portugal</option>
        <option value="Qatar">Qatar</option>
        <option value="Romania">Romania</option>
        <option value="Russia">Russia</option>
        <option value="Rwanda">Rwanda</option>
        <option value="Saint Kitts and Nevis">Saint Kitts and Nevis</option>
        <option value="Saint Lucia">Saint Lucia</option>
        <option value="Saint Vincent and the Grenadines">Saint Vincent and the Grenadines</option>
        <option value="Samoa">Samoa</option>
        <option value="San Marino">San Marino</option>
        <option value="Sao Tome and Principe">Sao Tome and Principe</option>
        <option value="Saudi Arabia">Saudi Arabia</option>
        <option value="Senegal">Senegal</option>
        <option value="Serbia">Serbia</option>
        <option value="Seychelles">Seychelles</option>
        <option value="Sierra Leone">Sierra Leone</option>
        <option value="Singapore">Singapore</option>
        <option value="Slovakia">Slovakia</option>
        <option value="Slovenia">Slovenia</option>
        <option value="Solomon Islands">Solomon Islands</option>
        <option value="Somalia">Somalia</option>
        <option value="South Africa">South Africa</option>
        <option value="South Korea">South Korea</option>
        <option value="South Sudan">South Sudan</option>
        <option value="Spain">Spain</option>
        <option value="Sri Lanka">Sri Lanka</option>
        <option value="Sudan">Sudan</option>
        <option value="Suriname">Suriname</option>
        <option value="Sweden">Sweden</option>
        <option value="Switzerland">Switzerland</option>
        <option value="Syria">Syria</option>
        <option value="Taiwan">Taiwan</option>
        <option value="Tajikistan">Tajikistan</option>
        <option value="Tanzania">Tanzania</option>
        <option value="Thailand">Thailand</option>
        <option value="Togo">Togo</option>
        <option value="Tonga">Tonga</option>
        <option value="Trinidad and Tobago">Trinidad and Tobago</option>
        <option value="Tunisia">Tunisia</option>
        <option value="Turkey">Turkey</option>
        <option value="Turkmenistan">Turkmenistan</option>
        <option value="Tuvalu">Tuvalu</option>
        <option value="Uganda">Uganda</option>
        <option value="Ukraine">Ukraine</option>
        <option value="United Arab Emirates">United Arab Emirates</option>
        <option value="United Kingdom">United Kingdom</option>
        <option value="United States">United States</option>
        <option value="Uruguay">Uruguay</option>
        <option value="Uzbekistan">Uzbekistan</option>
        <option value="Vanuatu">Vanuatu</option>
        <option value="Vatican City">Vatican City</option>
        <option value="Venezuela">Venezuela</option>
        <option value="Vietnam">Vietnam</option>
        <option value="Yemen">Yemen</option>
        <option value="Zambia">Zambia</option>
        <option value="Zimbabwe">Zimbabwe</option>
      </select>
    </span>
  </td>
  <td>&nbsp;</td>
</tr>

						  <tr>
						    <td>Beneficiary Account No/IBAN</td>
						    <td><span class="controls">
						      <input class="input-xlarge focused" id="act_number" name="act_number" type="text" value="" required />
						      </span></td>
						    <td>&nbsp;</td>
						    
					      </tr>
						  <tr>
						    <td><span>
						      <label for="typeahead2"> Beneficiary Bank Name </label>
						      </span></td>
						    <td><span class="controls">
						      <input class="input-xlarge focused" id="branch_name" name="branch_name" type="text" value="" required />
						      </span></td>
						    <td>&nbsp;</td>
					      </tr>
						  <tr>
						    <td><span>
                            <label for="typeahead4"> Beneficiary Bank Address </label>
                            </span></td>
						    <td><span class="controls">
						      <textarea name="branch_add" required ></textarea>
						    </span></td>
						    <td>&nbsp;</td>
					      </tr>
						  <tr>
						    <td><span>
						      <label for="typeahead3"> Beneficiary Swift Code</label>
						      </span></td>
						    <td><span class="controls">
						      <input class="input-xlarge focused" id="bank_name" name="swift" type="text" value="" required />
						      </span></td>
						    <td>&nbsp;</td>
					      </tr>
						  <tr>
						    <td>Beneficiary Bank Routing No/Sort Code</td>
						    <td><span class="controls">
						      <input class="input-xlarge focused" id="ifsc_code" name="ifsc_code" type="text" value="" required />
						    </span></td>
						    <td>&nbsp;</td>
					      </tr>
						  <tr>
						    <td colspan="2" class="form-actions" style="background: rgba(0, 0, 0, 0);color:white;color:white;font-size:20px;font-wight:bold">Fill below if there is an Intermediary Bank?</td>
						    <td>&nbsp;</td>
					      </tr>
						  <tr>
						    <td><label for="typeahead5">Intermediary Bank Name:</label></td>
						    <td><span class="controls">
					        <input type="text" name="inter_bank" id="inter_bank" /></span></td>
						    <td>&nbsp;</td>
					      </tr>
						  <tr>
						    <td><label for="typeahead6">Intermediary Bank Address:</label></td>
						    <td><span class="controls">
					        <input type="text" name="inter_address" id="inter_address" /></span></td>
						    <td>&nbsp;</td>
					      </tr>
						  <tr>
						    <td><label for="typeahead6">Intermediary Bank BIC/SWIFT Code:</label></td>
						    <td><span class="controls">
					        <input type="text" name="inter_swift" id="inter_swift" /></span></td>
						    <td>&nbsp;</td>
					      </tr>
						  <tr>
						    <td><label for="typeahead6">Intermediary Bank Routing No/Sort Code:</label></td>
						    <td><label for="inter_route"></label><span class="controls">
					        <input type="text" name="inter_route" id="inter_route" /></span></td>
						    <td>&nbsp;</td>
					      </tr>
						  <tr>
						    <td><label for="typeahead6">Beneficiary Bank Account With Intermediary Bank:</label></td>
						    <td><span class="controls">
					        <input type="text" name="inter_bank2" id="inter_bank" /></span></td>
						    <td>&nbsp;</td>
					      </tr>
						  <tr>
						    <td><label for="typeahead6">Purpose of Payment:</label></td>
						    <td><label for="purpose"></label><span class="controls">
					        <textarea class="input-xlarge focused" name="purpose" id="purpose"></textarea>						      <input name="number" type="hidden" id="number" value="<?php echo(mt_rand(10000,100000));?>" /></span></td>
						    <td>&nbsp;</td>
					      </tr>
						  <tr>
						    <td>&nbsp;</td>
						    <td>&nbsp;</td>
						    <td>&nbsp;</td>
					      </tr>
						  <tr>
						    <td>&nbsp;</td>
						    <td>&nbsp;</td>
						    <td>&nbsp;</td>
					      </tr>
						  <tr>
						    <td colspan="2"><div class="form-actions" style="background: rgba(0, 0, 0, 0);;padding:15px;color:white" > 
 
						      <button type="submit" class="btn btn-primary" name="transfer" >Begin Transfer Request</button>
						      <button type="reset" class="btn">Cancel</button>
					        </div></td>
						    <td>&nbsp;</td>
					      </tr>
				      </table>
												  </fieldset>
						</form>   

							<div class="control-group">
							  <div class="controls">
  <label for="prinacc"></label>
							  </div>
						    </div>
							<div class="control-group">
							  <div class="controls"></div>
						    </div>
							<div class="control-group">:
<div class="controls">
		      <label for="currency"></label>
</div>
						    </div>
	

					</div>
				</div><!--/span-->

			</div><!--/row-->



    
<?php include('footer.php'); ?>
<?php
//mysql_free_result($prinacc);
?>
